// tree.java
// Program demonstruje operacje na drzewach binarnych
// Aby uruchomi program: C>java TreeApp
import java.io.*;
import java.util.*;               // potrzebne bo uywamy klasy Stack
////////////////////////////////////////////////////////////////
class Node
   {
   public int iData;              // element danych (klucz)
   public double dData;           // element danych
   public Node leftChild;         // lewy potomek wza
   public Node rightChild;        // prawy lewy potomek wza

   public void displayNode()      // wywietlenie zawartoci wza
      {
      System.out.print('{');
      System.out.print(iData);
      System.out.print(", ");
      System.out.print(dData);
      System.out.print("} ");
      }
   }  // koniec klasy Node
////////////////////////////////////////////////////////////////
class Tree
   {
   private Node root;             // pierwszy wze drzewa

// -------------------------------------------------------------
   public Tree()                  // konstruktor
      { root = null; }            // na razie drzewo jest puste
// -------------------------------------------------------------
   public Node find(int key)      // odszukanie wza o podanej wartoci klucza
      {                           // (zakadamy, e drzewo nie jest puste)
      Node current = root;               // zaczynamy od korzenia drzewa
      while(current.iData != key)        // dopki nie odnaleziono,
         {
         if(key < current.iData)         // przechodzimy na lewo?
            current = current.leftChild;
         else                            // czy na prawo?
            current = current.rightChild;
         if(current == null)             // jeli brak potomka,
            return null;                 // nie odnaleziono wza
         }
      return current;                    // odnaleziono wze
      }  // koniec metody find()
// -------------------------------------------------------------
   public void insert(int id, double dd)
      {
      Node newNode = new Node();    // tworzymy nowy wze
      newNode.iData = id;           // zapisujemy w nim dane
      newNode.dData = dd;
      if(root==null)                // brak korzenia drzewa
         root = newNode;
      else                          // korze istnieje
         {
         Node current = root;       // zaczynamy poszukiwania od korzenia
         Node parent;
         while(true)                // (zakoczenie ptli wewntrz niej)
            {
            parent = current;
            if(id < current.iData)  // czy idziemy w lewo?
               {
               current = current.leftChild;
               if(current == null)  // jeli koniec linii,
                  {                 // wstawiamy po lewej stronie
                  parent.leftChild = newNode;
                  return;
                  }
               }  // koniec if (idziemy na lewo)
            else                    // czy idziemy na prawo?
               {
               current = current.rightChild;
               if(current == null)  // jeli koniec linii
                  {                 // wstawiamy po prawej stronie
                  parent.rightChild = newNode;
                  return;
                  }
               }  // koniec klauzuli else (idziemy na prawo)
            }  // koniec ptli while
         }  // koniec klauzuli else (korzen istnieje)
      }  // koniec metody insert()
// -------------------------------------------------------------
   public boolean delete(int key) // usunicie wza o podanej wartoci klucza
      {                           // (zakadamy e drzewo nie jest puste)
      Node current = root;
      Node parent = root;
      boolean isLeftChild = true;

      while(current.iData != key)        // szukamy wza
         {
         parent = current;
         if(key < current.iData)         // czy w lewo?
            {
            isLeftChild = true;
            current = current.leftChild;
            }
         else                            // czy w prawo?
            {
            isLeftChild = false;
            current = current.rightChild;
            }
         if(current == null)             // koniec,
            return false;                // nie znaleziono wza
         }  // koniec ptli while
      // znaleziono wze do usunicia

      // jeli nie ma potomkw, usuwamy wze
      if(current.leftChild==null &&
                                   current.rightChild==null)
         {
         if(current == root)             // jeli to korze,
            root = null;                 // oprniamy drzewo
         else if(isLeftChild)
            parent.leftChild = null;     // odczamy wze 
         else                            // od rodzica
            parent.rightChild = null;
         }

      // jeli brak prawego potomka, zastpujemy wze lewym poddrzewem
      else if(current.rightChild==null)
         if(current == root)
            root = current.leftChild;
         else if(isLeftChild)
            parent.leftChild = current.leftChild;
         else
            parent.rightChild = current.leftChild;

      // jeli brak lewego potomka, zastpujemy wze prawym poddrzewem
      else if(current.leftChild==null)
         if(current == root)
            root = current.rightChild;
         else if(isLeftChild)
            parent.leftChild = current.rightChild;
         else
            parent.rightChild = current.rightChild;

      else  // wze ma dwa potomki, zastpujemy go zatem jego nastpnikiem
         {
         // okrelamy nastpnika usuwanego wza (current)
         Node successor = getSuccessor(current);

         // czymy rodzica wza current z wzem successor
         if(current == root)
            root = successor;
         else if(isLeftChild)
            parent.leftChild = successor;
         else
            parent.rightChild = successor;

         // doczamy nastpnika do wza current jako lewego potomka
         successor.leftChild = current.leftChild;
         }  // koniec else - (gdy wze ma dwa potomki)
      // (nastpnik nie moe mie lewego potomka)
      return true;                                // udao si
      }  // koniec metody delete()
// -------------------------------------------------------------
   // metoda zwraca wze o kolejnej wartoci wikszej od wartoci
   // wza przekazanego jako argument delNode
   // metoda przechodzi do prawego potomka, a nastpnie do lewego 
   // potomka tego wzea i kolejnych wzw
   private Node getSuccessor(Node delNode)
      {
      Node successorParent = delNode;
      Node successor = delNode;
      Node current = delNode.rightChild;   // przechodzimy do prawego potomka
      while(current != null)               // do momentu gdy ju nie bdzie
         {                                 // lewych potomkw,
         successorParent = successor;
         successor = current;
         current = current.leftChild;      // przechodzimy do lewego potomka
         }
                                           // jeli nastpnik nie jest 
      if(successor != delNode.rightChild)  // prawym potomkiem,
         {                                 // doczamy go
         successorParent.leftChild = successor.rightChild;
         successor.rightChild = delNode.rightChild;
         }
      return successor;
      }
// -------------------------------------------------------------
   public void traverse(int traverseType)
      {
      switch(traverseType)
         {
         case 1: System.out.print("\nTrawersowanie w porzadku 'preorder': ");
                 preOrder(root);
                 break;
         case 2: System.out.print("\nTrawersowanie w porzadku 'inorder':  ");
                 inOrder(root);
                 break;
         case 3: System.out.print("\nTrawersowanie w porzadku 'postorder': ");
                 postOrder(root);
                 break;
         }
      System.out.println();
      }
// -------------------------------------------------------------
   private void preOrder(Node localRoot)
      {
      if(localRoot != null)
         {
         System.out.print(localRoot.iData + " ");
         preOrder(localRoot.leftChild);
         preOrder(localRoot.rightChild);
         }
      }
// -------------------------------------------------------------
   private void inOrder(Node localRoot)
      {
      if(localRoot != null)
         {
         inOrder(localRoot.leftChild);
         System.out.print(localRoot.iData + " ");
         inOrder(localRoot.rightChild);
         }
      }
// -------------------------------------------------------------
   private void postOrder(Node localRoot)
      {
      if(localRoot != null)
         {
         postOrder(localRoot.leftChild);
         postOrder(localRoot.rightChild);
         System.out.print(localRoot.iData + " ");
         }
      }
// -------------------------------------------------------------
   public void displayTree()
      {
      Stack globalStack = new Stack();
      globalStack.push(root);
      int nBlanks = 32;
      boolean isRowEmpty = false;
      System.out.println(
      "......................................................");
      while(isRowEmpty==false)
         {
         Stack localStack = new Stack();
         isRowEmpty = true;

         for(int j=0; j<nBlanks; j++)
            System.out.print(' ');

         while(globalStack.isEmpty()==false)
            {
            Node temp = (Node)globalStack.pop();
            if(temp != null)
               {
               System.out.print(temp.iData);
               localStack.push(temp.leftChild);
               localStack.push(temp.rightChild);

               if(temp.leftChild != null ||
                                   temp.rightChild != null)
                  isRowEmpty = false;
               }
            else
               {
               System.out.print("--");
               localStack.push(null);
               localStack.push(null);
               }
            for(int j=0; j<nBlanks*2-2; j++)
               System.out.print(' ');
            }  // koniec ptli while (globalStack nie jest pusty)
         System.out.println();
         nBlanks /= 2;
         while(localStack.isEmpty()==false)
            globalStack.push( localStack.pop() );
         }  // koniec ptli while (czy isRowEmpty wynosi false)
      System.out.println(
      "......................................................");
      }  // koniec metody displayTree()
// -------------------------------------------------------------
   }  // koniec klasy Tree
////////////////////////////////////////////////////////////////
class TreeApp
   {
   public static void main(String[] args) throws IOException
      {
      int value;
      Tree theTree = new Tree();

      theTree.insert(50, 1.5);
      theTree.insert(25, 1.2);
      theTree.insert(75, 1.7);
      theTree.insert(12, 1.5);
      theTree.insert(37, 1.2);
      theTree.insert(43, 1.7);
      theTree.insert(30, 1.5);
      theTree.insert(33, 1.2);
      theTree.insert(87, 1.7);
      theTree.insert(93, 1.5);
      theTree.insert(97, 1.5);

      while(true)
         {
         System.out.print("Wpisz litere by wykonac polecenie, ");
         System.out.print("(i)-wstaw, (f)-wyszukaj, (d)-usun, lub (t)-trawersowanie: ");
         int choice = getChar();
         switch(choice)
            {
            case 's':
               theTree.displayTree();
               break;
            case 'i':
               System.out.print("Wpisz wartosc klucza wstawianego wezla: ");
               value = getInt();
               theTree.insert(value, value + 0.9);
               break;
            case 'f':
               System.out.print("Wpisz wartosc klucza poszukiwanego wezla: ");
               value = getInt();
               Node found = theTree.find(value);
               if(found != null)
                  {
                  System.out.print("Znaleziono wezel: ");
                  found.displayNode();
                  System.out.print("\n");
                  }
               else
                  System.out.print("Nie udalo sie znalezc wezla o kluczu ");
                  System.out.print(value + '\n');
               break;
            case 'd':
               System.out.print("Podaj wartosc klucza usuwanego wezla: ");
               value = getInt();
               boolean didDelete = theTree.delete(value);
               if(didDelete)
                  System.out.print("Usunieto wezel " + value + '\n');
               else
                  System.out.print("Nie udalo sie usunac wezla o kluczu ");
                  System.out.print(value + '\n');
               break;
            case 't':
               System.out.print("Wpisz 1, 2 lub 3: ");
               value = getInt();
               theTree.traverse(value);
               break;
            default:
               System.out.print("Nieprawidlowe dane\n");
            }  // koniec instrukcji switch
         }  // koniec petli while
      }  // koniec metody main()
// -------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
// -------------------------------------------------------------
   public static char getChar() throws IOException
      {
      String s = getString();
      return s.charAt(0);
      }
//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
// -------------------------------------------------------------
   }  // koniec klasy TreeApp
////////////////////////////////////////////////////////////////
